/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.problem;

import com.ibm.hwmca.fw.pa.config.ProblemManagerData;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemAlreadyRegisteredException;
import com.ibm.hwmca.fw.pa.problem.ProblemClosingException;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.ProblemOpeningException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventAlreadyRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventManager;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventNotRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceNotInitializedException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ProblemManager
extends ServiceableEventManager {
    private static final String TRACE_MASKT = "XPAPROMT";
    private static final String TRACE_MASKF = "XPAPROMF";
    private static final String TRACE_MASKD = "XPAPROMD";
    public static final String PROPERTY_PROBLEM_PREFIX = "Problem";
    public static final String PROPERTY_PROBLEM_INVENTORY = "ProblemInventoryProperty";
    public static final String PROPERTY_PROBLEM_CLOSE = "ProblemCloseProperty";
    public static final String PROPERTY_PROBLEM_OPEN = "ProblemOpenProperty";
    public static final String PROPERTY_PROBLEM_CHANGED = "ProblemChangedProperty";
    private static ProblemManager problemManager = null;
    private static boolean problemsLoaded = false;

    private ProblemManager() {
    }

    public static synchronized ProblemManager getProblemManager() throws PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKD, "-> ProblemManager.getProblemManager()");
        if (problemManager == null) {
            Trace.trace(TRACE_MASKD, "<-! ProblemManager.getProblemManager() No persistence what so ever?");
            throw new PersistenceNotInitializedException("No persistence what so ever?");
        }
        if (!problemsLoaded) {
            Trace.trace(TRACE_MASKD, "loading problems");
            try {
                try {
                    problemManager.loadServiceableEvents();
                    List problems = problemManager.getAllServiceableEvents();
                    int nextProblem = 0;
                    Iterator iterator = problems.iterator();
                    while (iterator.hasNext()) {
                        nextProblem = Math.max(nextProblem, ((Problem)iterator.next()).getProblemNumber());
                    }
                    Problem.setNextProblemNumber(nextProblem + 1);
                    Trace.trace(TRACE_MASKD, "setting NEXT problem number to " + (nextProblem + 1));
                }
                catch (ServiceableEventPersistenceException e) {
                    Trace.trace(TRACE_MASKT, "<-! ProblemManager.getProblemManager: Exception");
                    Trace.trace(TRACE_MASKT, e);
                    throw new ProblemPersistenceException(e);
                }
                catch (ServiceableEventPersistenceNotInitializedException e) {
                    Trace.trace(TRACE_MASKT, "<-! ProblemManager.getProblemManager: Exception");
                    Trace.trace(TRACE_MASKT, e);
                    throw new PersistenceNotInitializedException(e);
                }
                Object var4_5 = null;
                problemsLoaded = true;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                problemsLoaded = true;
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKD, "<- ProblemManager.getProblemManager()");
        return problemManager;
    }

    public static synchronized void setConfigData(ProblemManagerData configData) throws PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKD, "--> ProblemManager.setConfigData");
        if (problemManager == null) {
            problemManager = new ProblemManager();
        }
        try {
            problemManager.addPersistenceConfigData(configData);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.setConfigData: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        Trace.trace(TRACE_MASKD, "<-- ProblemManager.setConfigData");
    }

    public static void reLoadPersistedProblems(ProblemManager ourManager) throws ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKD, "-> ProblemManager.reLoadPersistedProblems()");
        Trace.trace(TRACE_MASKD, "loading problems");
        try {
            try {
                ourManager.loadServiceableEvents();
                List problems = ourManager.getAllServiceableEvents();
                int nextProblem = 0;
                Iterator iterator = problems.iterator();
                while (iterator.hasNext()) {
                    nextProblem = Math.max(nextProblem, ((Problem)iterator.next()).getProblemNumber());
                }
                Problem.setNextProblemNumber(nextProblem + 1);
                Trace.trace(TRACE_MASKD, "setting NEXT problem number to " + nextProblem + 1);
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.reLoadPersistedProblems: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.reLoadPersistedProblems: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            Object var5_6 = null;
            problemsLoaded = true;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            problemsLoaded = true;
            throw throwable;
        }
        Trace.trace(TRACE_MASKD, "<- ProblemManager.reloadPersistedProblems()");
    }

    public Problem getProblem(String key) {
        return (Problem)super.getServiceableEvent(key);
    }

    public List getAllProblems() {
        ArrayList myArrayList = new ArrayList();
        myArrayList.addAll(super.getAllServiceableEvents());
        return (List)myArrayList.clone();
    }

    public synchronized void addProblem(Problem problem) throws ProblemAlreadyRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.addProblem problem[" + problem + "]");
        try {
            super.add(problem);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, problem);
        }
        catch (ServiceableEventAlreadyRegisteredException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemAlreadyRegisteredException(e);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.addProblem");
    }

    public synchronized void removeProblem(Problem problem) throws ProblemNotRegisteredException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.removeProblem problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Specified problem did not exist");
            throw new ProblemNotRegisteredException("Specified problem did not exist");
        }
        try {
            super.remove(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, p);
        }
        catch (ServiceableEventNotRegisteredException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemNotRegisteredException(e);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.removeProblem");
    }

    public synchronized void open(Problem problem) throws PropertyVetoException, ProblemOpeningException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.open problem[" + problem + "]");
        boolean alreadyAdded = false;
        if (this.serviceableEvents.contains(problem)) {
            alreadyAdded = true;
        }
        if (problem.isVetoable()) {
            this.vetoChangeSupport.fireVetoableChange(PROPERTY_PROBLEM_OPEN, problem, null);
        } else {
            Trace.trace(TRACE_MASKF, "this problem doesn't allow vetos");
        }
        problem.open();
        problem.assignProblemNumber();
        problem.setProblemState(1);
        if (!alreadyAdded) {
            try {
                super.add(problem);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, problem);
            }
            catch (ServiceableEventAlreadyRegisteredException e) {
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
        } else {
            try {
                super.getServiceableEventPersistence(problem.getClass()).store(problem);
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_OPEN, problem, null);
        Trace.trace(TRACE_MASKT, "<- ProblemManager.open");
    }

    public synchronized void changed(Problem problem) throws ProblemNotRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.changed problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null || p != problem) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Specified problem did not exist/may have been replaced");
            throw new ProblemNotRegisteredException("Specified problem did not exist/may have been replaced");
        }
        try {
            super.changed(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_CHANGED, p, null);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.changed");
    }

    public synchronized void secondaryChanged(Problem problem) throws ProblemNotRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.secondaryChanged problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Specified problem did not exist");
            throw new ProblemNotRegisteredException("Specified problem did not exist");
        }
        try {
            this.serviceableEvents.remove(p);
            this.getServiceableEventPersistence(p.getClass()).remove(p);
            this.serviceableEvents.add(problem);
            super.changed(problem);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.secondaryChanged");
    }

    public synchronized void close(Problem problem) throws ProblemNotRegisteredException, PropertyVetoException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.close problem[" + problem + "]");
        if (problem instanceof CommonProblem && DistributedAnalysisDomain.attemptProblemActionRedirection((CommonProblem)problem, "PART_DAD_PROB_CLOSE")) {
            Trace.trace(TRACE_MASKT, "<-- ProblemManager.close()");
            return;
        }
        this.primaryClose(problem);
        Trace.trace(TRACE_MASKT, "<- ProblemManager.close");
    }

    public synchronized void primaryClose(Problem problem) throws ProblemNotRegisteredException, PropertyVetoException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.primaryClose problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null || p != problem) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Specified problem did not exist/may have been replaced");
            throw new ProblemNotRegisteredException("Specified problem did not exist/may have been replaced");
        }
        try {
            if (p.isVetoable()) {
                this.vetoChangeSupport.fireVetoableChange(PROPERTY_PROBLEM_CLOSE, p, null);
            } else {
                Trace.trace(TRACE_MASKF, "this problem doesn't allow vetos");
            }
            p.close();
            p.setProblemState(2);
            super.changed(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_CLOSE, p, null);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.primaryClose");
    }

    public synchronized void secondaryClose(Problem problem) throws ProblemNotRegisteredException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.secondaryClose problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose: specified problem did not exist");
            throw new ProblemNotRegisteredException("ProblemManager.secondaryClose: specified problem did not exist");
        }
        try {
            p.close();
            p.setProblemState(2);
            super.changed(p);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose exception caught:[" + e + "]");
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose exception caught:[" + e + "]");
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.secondaryClose");
    }
}

